<?php

namespace Tests\Unit;

use App\Modules\Finance\Services\CodeWeavers;
use App\Modules\Finance\Services\IVendi;
use App\Modules\Finance\Services\IVendiPeterVardy;
use Tests\TestCase;

class FinanceUnitTest extends TestCase
{
    public function testCodeWeaversDealershipFields()
    {
        $fields = (new CodeWeavers())->dealershipAdditionalDataFields();
        $this->assertArrayHasKey('codeweavers', $fields);
        $this->assertArrayHasKey('codeweavers-product-keys', $fields);
    }

    public function testIVendiDealershipFields()
    {
        $fields = (new IVendi())->dealershipAdditionalDataFields();
        $this->assertArrayHasKey('ivendi', $fields);
        $this->assertArrayHasKey('ivendi-dealer-key', $fields);
        $this->assertArrayHasKey('finance-risk-based-pricing', $fields);
    }

    public function testIVendiPVDealershipFields()
    {
        $fields = (new IVendiPeterVardy())->dealershipAdditionalDataFields();
        $this->assertArrayHasKey('ivendi', $fields);
        $this->assertArrayHasKey('ivendi-dealer-key', $fields);
        $this->assertArrayHasKey('finance-risk-based-pricing', $fields);
    }
}
