<?php

namespace Tests\Unit;

use App\Facades\Settings;
use App\Mail\NewEnquiryMail;
use Carbon\Carbon;
use Database\Seeders\Global\CountrySeeder;
use Database\Seeders\Tenant\RapidRTCSettingSeeder;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Facades\Mail;
use Mtc\Crm\Facades\Enquiries;
use Mtc\Crm\Models\Enquiry;
use Mtc\Crm\Models\EnquiryAction;
use Mtc\MercuryDataModels\Dealership;
use Tests\TenantTestCase;
use Tests\TestCase;
use Tests\UserForTenant;

class SendToRapidRTCControllerTest extends TestCase
{
    use RefreshDatabase;
    use UserForTenant;

    public $tenancy = true;

    /**
     * A basic unit test example.
     *
     * @return void
     */
    public function testShowDealerHasRapidRtcField()
    {
        $this->seed(RapidRTCSettingSeeder::class);
        Settings::update('crm-rapid-rtc-enabled', true);

        $dealership = Dealership::factory()->create(['name' => 'foo']);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.dealerships.show', $dealership->id));

        $response->assertStatus(200);
        $this->assertIsArray($response->json('dealership.data_fields'));
        $this->assertEquals('rapid-rtc-mailbox', $response->json('dealership.data_fields.0.id'));
    }

    public function testUpdateDealerChecksRapidRtcFields()
    {
        $this->seed(CountrySeeder::class);
        $this->seed(RapidRTCSettingSeeder::class);
        Settings::update('crm-rapid-rtc-enabled', true);

        $dealership = Dealership::factory()->create(['name' => 'foo']);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->putJson(route('tenant.dealerships.update', $dealership->id), [
                'name' => 'baz',
                'email' => 'john@example.com',
                'contact_no' => '123123',
                'address1' => 'foo',
                'address2' => 'baz',
                'city' => 'bar',
                'county' => 'foo-baz',
                'postcode' => '1004',
                'country' => 'LV',
            ]);

        $response->assertStatus(422);
        $this->assertArrayHasKey('data.rapid-rtc-mailbox', $response->json('errors'));
    }
}
