<?php

namespace App;

use App\Mail\NewUnmappedTaxonomyMail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\Relations\MorphToMany;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Mtc\MercuryDataModels\NewCar;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleOffer;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class TaxonomyMapable extends Model
{
    use CentralConnection;

    protected $fillable = [
        'tenant',
        'taxonomy_map_id',
        'mappable_type',
        'mappable_id',
    ];

    public $timestamps = false;

    public function taxonomyMap(): BelongsTo
    {
        return $this->belongsTo(TaxonomyMap::class);
    }
}
