<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SkupenetNewVehicleStockSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Skupenet',
                'name' => 'New vehicle mileage threshold',
                'config_key' => 'stock-skupenet-new-vehicle-mileage-threshold',
                'type' => 'int',
                'min_tier' => 'standard',
                'value' => 0,
                'order' => 6,
                'description' => ''
            ],
        ];
    }
}
