<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class StormMsDynamicsSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Storm.ie MS Dynamics connector',
                'name' => 'Enabled',
                'config_key' => 'storm-ms-dynamics-crm-enabled',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Connect to MS Dynamics through Storm.ie connector.'
            ],
        ];
    }
}
