<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ValuationSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Valuation',
                'name' => 'Enabled',
                'config_key' => 'valuation-auto-trader-enabled',
                'type' => 'boolean',
                'min_tier' => 'pro',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Valuation',
                'name' => 'Set vehicle RRP price based on valuation',
                'config_key' => 'automotive-valuations-auto-trader-set-rrp-price',
                'type' => 'boolean',
                'min_tier' => 'pro',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Valuation',
                'name' => 'Price to set from valuation',
                'config_key' => 'automotive-valuations-auto-trader-select-price',
                'type' => 'string',
                'min_tier' => 'pro',
                'value' => false,
                'choices' => [
                    [ "value" => "trade", "name" => "Trade Price" ],
                    [ "value" => "partExchange", "name" => "Part Exchange" ],
                    [ "value" => "retail", "name" => "Retail" ],
                    [ "value" => "private", "name" => "Private" ],
                ]
            ],
        ];
    }
}
