<?php

namespace App\Http\Controllers;

use App\Http\Resources\TemplateUsageListResource;
use App\Jobs\SyncContentToTemplate;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Mtc\ContentManager\Contracts\PageModel;
use Mtc\MercuryDataModels\NewCar;
use Mtc\MercuryDataModels\Template;
use Mtc\MercuryDataModels\VehicleOffer;

class TemplateController extends Controller
{
    use DispatchesJobs;

    public function usage(Template $template): TemplateUsageListResource
    {
        $entries = $template->pages()
            ->with([
                'template.elements.element.fields',
                'content.mediaUses.media',
                'content.subContent.mediaUses.media',
                'content.subContent.subContent.mediaUses.media',
                'content.subContent.subContent.subContent.mediaUses.media',
                'content.globalContent.contentElement.fields',
                'content.contentElement.fields',
                'content.subContent.contentElement.fields',
                'content.subContent.subContent.contentElement.fields',
                'content.subContent.subContent.subContent.contentElement.fields',
            ])
            ->get();

        $template->offers()
            ->with([
                'template.elements.element.fields',
                'content.mediaUses.media',
                'content.subContent.mediaUses.media',
                'content.subContent.subContent.mediaUses.media',
                'content.subContent.subContent.subContent.mediaUses.media',
                'content.globalContent.contentElement.fields',
                'content.contentElement.fields',
                'content.subContent.contentElement.fields',
                'content.subContent.subContent.contentElement.fields',
                'content.subContent.subContent.subContent.contentElement.fields',
            ])
            ->get()
            ->each(fn($offer) => $entries->push($offer));

        $template->newVehicles()
            ->with([
                'template.elements.element.fields',
                'content.mediaUses.media',
                'content.subContent.mediaUses.media',
                'content.subContent.subContent.mediaUses.media',
                'content.subContent.subContent.subContent.mediaUses.media',
                'content.globalContent.contentElement.fields',
                'content.contentElement.fields',
                'content.subContent.contentElement.fields',
                'content.subContent.subContent.contentElement.fields',
                'content.subContent.subContent.subContent.contentElement.fields',
            ])
            ->get()
            ->each(fn($new_vehicle) => $entries->push($new_vehicle));

        return new TemplateUsageListResource($entries);
    }

    public function syncUsage(Template $template): TemplateUsageListResource
    {
        $template->pages()->get()
            ->each(fn(PageModel $page) => $this->dispatch(new SyncContentToTemplate($page)));
        $template->offers()->get()
            ->each(fn(VehicleOffer $offer) => $this->dispatch(new SyncContentToTemplate($offer)));
        $template->newVehicles()->get()
            ->each(fn(NewCar $newCar) => $this->dispatch(new SyncContentToTemplate($newCar)));
        return $this->usage($template);
    }
}
