<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class VehicleUrlWwwSettingSeeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Vehicles',
                'name' => 'Include www in vehicle page URL path',
                'config_key' => 'vehicles-url-path-include-www',
                'type' => 'boolean',
                'value' => false,
            ],
        ];
    }
}
