@extends('crm::emails.layout', [
    'subject' => 'API Credentials Expiring',
])

@section('content')
<p>The following API credentials are expiring <strong>{{ $timeframe }}</strong> and require renewal:</p>

@if($oauthUsers->isNotEmpty())
<h3>OAuth API Users</h3>
<p>These users need their OAuth credentials regenerated:</p>
<table style="width: 100%; border-collapse: collapse; margin-bottom: 20px;">
    <thead>
        <tr style="background-color: #f5f5f5;">
            <th style="padding: 10px; border: 1px solid #ddd; text-align: left;">Name</th>
            <th style="padding: 10px; border: 1px solid #ddd; text-align: left;">Client ID</th>
            <th style="padding: 10px; border: 1px solid #ddd; text-align: left;">Expiry Date</th>
        </tr>
    </thead>
    <tbody>
        @foreach($oauthUsers as $user)
        <tr>
            <td style="padding: 10px; border: 1px solid #ddd;">{{ $user->name }}</td>
            <td style="padding: 10px; border: 1px solid #ddd;">{{ $user->client_id }}</td>
            <td style="padding: 10px; border: 1px solid #ddd;">{{ $user->credentials_due_for_update_at->format('Y-m-d') }}</td>
        </tr>
        @endforeach
    </tbody>
</table>
@endif

@if($persistentTokens->isNotEmpty())
<h3>Persistent Tokens</h3>
<p>These tokens need to be renewed:</p>
<table style="width: 100%; border-collapse: collapse; margin-bottom: 20px;">
    <thead>
        <tr style="background-color: #f5f5f5;">
            <th style="padding: 10px; border: 1px solid #ddd; text-align: left;">API User</th>
            <th style="padding: 10px; border: 1px solid #ddd; text-align: left;">Token (last 8 chars)</th>
            <th style="padding: 10px; border: 1px solid #ddd; text-align: left;">Expiry Date</th>
        </tr>
    </thead>
    <tbody>
        @foreach($persistentTokens as $token)
        <tr>
            <td style="padding: 10px; border: 1px solid #ddd;">{{ $token->apiUser->name ?? 'Unknown' }}</td>
            <td style="padding: 10px; border: 1px solid #ddd;">...{{ substr($token->token, -8) }}</td>
            <td style="padding: 10px; border: 1px solid #ddd;">{{ $token->expires_at->format('Y-m-d') }}</td>
        </tr>
        @endforeach
    </tbody>
</table>
@endif

<p style="margin-top: 20px;">
    <strong>Action required:</strong> Please log in to the admin panel and regenerate the credentials before they expire to avoid service interruption.
</p>
@endsection
