<?php

namespace Tests\Unit;

use App\Rules\SettingTypeRule;
use App\Rules\StringContainsStringRule;
use Tests\TestCase;

class RuleTest extends TestCase
{
    public function testSettingTypeRule()
    {
        $tests = [
            'boolean' => true,
            'image' => true,
            'secret' => true,
            'string' => true,
            'int' => true,
            'verify' => true,
            'foo' => false,
            'lorem' => false,
            'test' => false,
        ];
        foreach ($tests as $type => $value) {
            $this->assertEquals($value, (new SettingTypeRule())->passes('field', $type));
        }

        $this->assertStringContainsString('valid setting type', (new SettingTypeRule())->message());
    }

    public function testStringContainsString()
    {
        $this->assertTrue((new StringContainsStringRule('foo'))->passes('field', 'foo baz bar'));
        $this->assertTrue((new StringContainsStringRule('baz'))->passes('field', 'foo baz bar'));
        $this->assertFalse((new StringContainsStringRule('hello'))->passes('field', 'foo baz bar'));
        $this->assertFalse((new StringContainsStringRule('lorem'))->passes('field', 'foo baz bar'));
        $this->assertStringContainsString('must contain', (new StringContainsStringRule('foo'))->message());
        $this->assertStringContainsString('foo', (new StringContainsStringRule('foo'))->message());
    }
}
