<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class EmailWhitelistSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        collect($this->getData())
            ->each(fn ($data) => Settings::make($data));
    }

    private function getData(): array
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'Mail',
                'group' => 'Email Whitelist',
                'name' => 'Whitelisted Email Addresses',
                'config_key' => 'mail-whitelist-emails',
                'type' => 'text',
                'description' => 'Comma-separated list of email addresses allowed to receive emails in non-live environments. Site users are automatically whitelisted.',
                'order' => 20,
            ],
            [
                'tab' => 'Site',
                'section' => 'Mail',
                'group' => 'Email Whitelist',
                'name' => 'Enable Email Whitelist',
                'config_key' => 'mail-whitelist-enabled',
                'type' => 'boolean',
                'value' => 1,
                'description' => 'When enabled, only whitelisted emails and site users will receive emails. Automatically disabled when site goes live.',
                'order' => 19,
            ],
        ];
    }
}
