<?php

namespace Database\Seeders\Tenant;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Mtc\MercuryDataModels\Setting;

/**
 * Migrates the deprecated auto-set-original-price setting to
 * vehicles-price-change-updates-original-price.
 */
class MigrateAutoSetOriginalPriceSeeder extends Seeder
{
    public function run(): void
    {
        $autoSetOriginalPrice = Setting::query()
            ->where('config_key', 'auto-set-original-price')
            ->value('value');

        // If the deprecated setting was enabled, enable the new setting
        if ($autoSetOriginalPrice) {
            Setting::query()
                ->where('config_key', 'vehicles-price-change-updates-original-price')
                ->update(['value' => '1']);
        }

        Setting::query()
            ->where('config_key', 'auto-set-original-price')
            ->delete();
    }
}
