<?php

namespace App\Checklist;

use App\Contracts\GoLiveChecklist;
use Mtc\MercuryDataModels\SeoData;

class SeoDataImported extends GoLiveChecklist
{
    public function category(): string
    {
        return GoLiveChecklist::MARKETING;
    }

    public function key(): string
    {
        return 'seo_data_imported';
    }

    public function requiresManualConfirm(): bool
    {
        return true;
    }

    public function handle(): bool
    {
        return false;
    }

    public function name(): string
    {
        return __('go-live.names.' . $this->key(), [
            'seo_data_count' => SeoData::query()->count(),
        ]);
    }
}
