<?php

namespace App\ReportTypes;

use Illuminate\Database\Eloquent\Builder;
use Mtc\MercuryDataModels\VehicleOffer;

class OfferReport
{
    /**
     * Report name
     *
     * @return string
     */
    public function name(): string
    {
        return 'Offers';
    }

    /**
     * Columns that can be used
     *
     * @return string[]
     */
    public function columns(): array
    {
        return [
            'slug' => 'URL ID',
            'type' => 'Type',
            'name' => 'Name',
            'make.name' => 'Vehicle make',
            'model.name' => 'Vehicle model',
            'price' => 'Price',
            'mediaUses.count' => 'Image count',
            'mediaUses.url' => 'Image URLs',
            'allEnquiries.count' => 'Total Enquiry Count',
            'currentMonthEnquiries.count' => 'Enquiry Count This month',
        ];
    }

    /**
     * Start a query
     *
     * @return Builder
     */
    public function query(): Builder
    {
        return VehicleOffer::query();
    }
}
