<?php

namespace App\Reporting;

use App\Contracts\ReportTile;
use Mtc\MercuryDataModels\Form;

class ActiveFormCountTile extends ReportTile
{
    private $value;

    public function name(): string
    {
        return 'Active Forms';
    }

    public function value(): mixed
    {
        if (empty($this->value)) {
            $this->value = Form::query()
                ->where('is_active', 1)
                ->count();
        }
        return $this->value;
    }

    public function difference(): mixed
    {
        return 0;
    }

    public function secondaryValue(): mixed
    {
        return 0;
    }

    public function subtitle(): string
    {
        return '';
    }

    public function differenceType(): string
    {
        if ($this->difference() > 0) {
            return 'positive';
        }
        return $this->difference() < 0
            ? 'negative'
            : 'noChange';
    }

    public function secondaryValueName(): string
    {
        return '';
    }
}
