<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;
use Illuminate\Support\Str;

class Password extends \Laravel\Fortify\Rules\Password
{
    /**
     * The minimum length of the password.
     *
     * @var int
     */
    protected $length = 13;

    /**
     * Indicates if the password must contain one uppercase character.
     *
     * @var bool
     */
    protected $requireUppercase = true;

    /**
     * Indicates if the password must contain one numeric digit.
     *
     * @var bool
     */
    protected $requireNumeric = true;

    /**
     * Indicates if the password must contain one special character.
     *
     * @var bool
     */
    protected $requireSpecialCharacter = true;

    /**
     * The message that should be used when validation fails.
     *
     * @var string
     */
    protected $message;
}
