<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class ChannelPagination extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Channable / FB Marketplace',
                'name' => 'Enable Pagination',
                'type' => 'boolean',
                'config_key' => 'sales-channels-channel-feed-pagination-enabled',
                'description' => 'Return feed in json format',
                'value' => false,
                'order' => 27,
            ],
        ];
    }
}
