@extends('crm::emails.pck.layout-vehicle', [
   'subject' => $enquiry->subject ?? 'Thank you for your enquiry',
   'site_name' => $site_name,
   'site_logo' => $site_logo,
   'site_url' => $site_url,
   'colours' => $colours,
   'header_image' => "enquiry-hero.png",
   'top_title' => "Thanks for your interest - <p style='padding-top: 15px;'>we're all ears!</p>",
   'description' => "One of our awesome PCK team members will be in touch soon to chat about your enquiry.<p style='padding-top: 15px;'>No need to wait around, though!</p>"
])

@php
    $formattedDetails = [];
    foreach ($enquiry->getNormalizedAnswers() as $detail) {
        switch ($detail['question']) {
            case 'First name (*)':
                $formattedDetails['name'] = $detail['answer'];
                break;
            case 'Email address (*)':
                $formattedDetails['email'] = $detail['answer'];
                break;
            case 'Message':
                $formattedDetails['message'] = $detail['answer'];
                break;
            case 'Mobile number (*)':
                $formattedDetails['contact_number'] = $detail['answer'];
                break;
            default:
                break;
        }
    }
@endphp

@php
    $vehicleDetails = [];
    if (!is_null($enquiry->reason)) {
        $vehicle = $enquiry->reason;

        $vehicleDetails = [
            'Make' => $vehicle?->make?->name,
            'Model' => $vehicle?->model?->name,
            'Derivative' => $vehicle?->derivative,
            'Registration' => $vehicle?->registration_number,
            'Mileage' => $vehicle?->odometer_mi,
            'RetailValue' => $vehicle?->price,
        ];
    }
@endphp

@php
    $finance_url = \App\Facades\Site::url('/finance');
    $reserve_url = "";

    if ($enquiry->reason && $enquiry->reason instanceof \Mtc\MercuryDataModels\Vehicle) {
        $reserve_url = \App\Facades\Site::vehicleUrl($enquiry->reason) . '?journey=reserve';
    }

    $faq = [
        [
            "icon" => "time.png",
            "question" => "How long does it take to get a finance quotation?",
            "answer" => "We always aim for a same working day quote."
        ],
        [
            "icon" => "money.png",
            "question" => "Can I reserve my car?",
            "answer" => "Yes you can. You can reserve your vehicle with a fully refundable £99 deposit."
        ],
        [
            "icon" => "deposit.png",
            "question" => "Can I get my deposit back if I cancel?",
            "answer" => "If for any reason you don't proceed, we will refund your deposit, no questions asked."
        ]
    ];
@endphp

@section('content')
    <tr>
        <td valign="top" bgcolor="#242424" style="background-color:#242424">
            <table
                cellpadding="0"
                cellspacing="0"
                border="0"
                align="center"
                width="100%">

                @if ($formattedDetails || $vehicleDetails)
                    @include('crm::emails.pck.modules.details', ['details' => $formattedDetails, 'enquiry' => true, 'vehicle' => $vehicleDetails])
                @endif

                @if ($reserve_url !== "")
                    @include('crm::emails.pck.modules.reserve')
                @endif

                @include('crm::emails.pck.modules.credit-check')
                @include('crm::emails.pck.modules.reviews')
                @include('crm::emails.pck.modules.contacts')
                @include('crm::emails.pck.modules.faq', ['enquiry' => true])
            </table>
        </td>
    </tr>
@endsection
