<?php

namespace App\Modules\ServiceBooking\Http\Resources;

use App\Traits\MakeAndModelList;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ViewServicePackage extends JsonResource
{
    use MakeAndModelList;

    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $this->resource->package_types = [
            [
                'id' => 'package',
                'name' => 'Package',
            ],
            [
                'id' => 'add-on',
                'name' => 'Add-on',
            ],
        ];
        $this->resource->makes = $this->getMakeList();
        return parent::toArray($request);
    }
}
