 @extends('crm::emails.john-banks.layout', [
    'subject' => $booking->subject ?? 'We have received your service booking',
    'site_name' => $site_name,
    'site_logo' => $site_logo,
    'site_url' => $site_url,
    'colours' => $colours,
])

@section('content')
    <!-- ALERT BLOCK -->
    <tr>
        <td valign="top">
            <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
                <tr>
                    <td valign="top" width="50"></td>
                    <td valign="top">
                        <table cellpadding="30" cellspacing="0" border="0" width="100%" bgcolor="{{ $colours['app-primary-colour'] }}" style="background-color:{{ $colours['app-primary-colour'] }};border-radius:10px;">
                            <tr>
                                <td valign="top" align="center">
                                    <table cellpadding="0" cellspacing="0" border="0" align="center">
                                        <tr>
                                            <td valign="middle" align="center">
                                                <img class="imageFix" src="{{ config('app.url') . '/api/assets/john-banks/icons/circle-check.png' }}" alt="Circle Check" title="Circle Check" width="58" height="58" style="display:block; outline:none; text-decoration:none; -ms-interpolation-mode: bicubic; border:none;" />
                                            </td>
                                            <td valign="middle" width="10"></td>
                                            <td valign="middle" align="center">
                                                <h1 style="color:#FFFFFF !important; margin:0; font-size:32px; font-weight:600; letter-spacing:-0.6px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                    {{ $booking->subject ?? 'Service booking confirmed' }}
                                                </h1>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </td>
                    <td valign="top" width="50"></td>
                </tr>
                <tr>
                    <td valign="top" height="50"></td>
                </tr>
            </table>
        </td>
    </tr>
    <!-- END OF ALERT BLOCK -->
    <tr>
        <td valign="top">
            <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
                <tr>
                    <td valign="top" width="50"></td>
                    <td valign="top">
                        <table cellpadding="0" cellspacing="0" border="0" width="100%">
                            <tr>
                                <td background="{{ config('app.url') . '/api/assets/john-banks/valuation-background-image.png' }}" bgcolor="#20292E" valign="bottom" style="border-radius: 10px 10px 0px 0px;" height="175">
                                    <!--[if gte mso 9]>
                                            <v:rect xmlns:v="urn:schemas-microsoft-com:vml" fill="true" stroke="false" style="mso-width-percent:1000; height:175px;">
                                                <v:fill type="tile" src="{{ config('app.url') . '/api/assets/john-banks/valuation-background-image.png' }}" color="#20292E" />
                                                <v:textbox style="mso-fit-shape-to-text:true" inset="0,0,0,0">
                                            <![endif]-->
                                    <div>
                                        <table cellpadding="40" cellspacing="0" border="0" width="100%">
                                            <tr>
                                                <td valign="top" align="left">
                                                    <p style="color:#FFFFFF; margin:0; font-size:40px; font-weight:700; letter-spacing:-0.8px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">Your booking details</p>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                    <!--[if gte mso 9]>
                                    </v:textbox>
                                    </v:rect>
                                    <![endif]-->
                                </td>
                            </tr>
                            <tr>
                                <td valign="top" height="20" bgcolor="#F2F5F7" style="background-color:#F2F5F7;"></td>
                            </tr>
                            <tr>
                                <td valign="top">
                                    <table cellpadding="0" cellspacing="0" border="0" width="100%">
                                        <tr>
                                            <td valign="top" width="40" bgcolor="#F2F5F7" style="background-color:#F2F5F7;"></td>
                                            <td valign="top">
                                                <table cellpadding="0" cellspacing="0" border="0" width="100%" bgcolor="#F2F5F7" style="background-color:#F2F5F7;">
                                                    <tr>
                                                        <td valign="top" width="180">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:400; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                Registration Number
                                                            </p>
                                                        </td>
                                                        <td valign="top">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:700; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                {{ $booking->registration_number }}
                                                            </p>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td valign="top" height="20"></td>
                                                    </tr>
                                                    <tr>
                                                        <td valign="top" width="180">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:400; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                Mileage
                                                            </p>
                                                        </td>
                                                        <td valign="top">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:700; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                {{ number_format($booking->mileage) }} miles
                                                            </p>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td valign="top" height="20"></td>
                                                    </tr>
                                                    <tr>
                                                        <td valign="top" width="180">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:400; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                Booking Time
                                                            </p>
                                                        </td>
                                                        <td valign="top">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:700; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                {{ \Carbon\Carbon::parse($booking->booking_time)->format('l, jS F Y \a\t g:i A') }}
                                                            </p>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td valign="top" height="20"></td>
                                                    </tr>
                                                    <tr>
                                                        <td valign="top" width="180">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:400; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                Name
                                                            </p>
                                                        </td>
                                                        <td valign="top">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:700; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                {{ $booking->first_name }} {{ $booking->last_name }}
                                                            </p>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td valign="top" height="20"></td>
                                                    </tr>
                                                    <tr>
                                                        <td valign="top" width="180">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:400; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                Email
                                                            </p>
                                                        </td>
                                                        <td valign="top">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:700; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                {{ $booking->email }}
                                                            </p>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td valign="top" height="20"></td>
                                                    </tr>
                                                    <tr>
                                                        <td valign="top" width="180">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:400; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                Phone
                                                            </p>
                                                        </td>
                                                        <td valign="top">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:700; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                {{ $booking->phone_number }}
                                                            </p>
                                                        </td>
                                                    </tr>
                                                    @if(!empty($booking->packages) && $booking->packages->count() > 0)
                                                    <tr>
                                                        <td valign="top" height="20"></td>
                                                    </tr>
                                                    <tr>
                                                        <td valign="top" width="180">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:400; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                Packages
                                                            </p>
                                                        </td>
                                                        <td valign="top">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:700; line-height:28px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                {!! $booking->packages->pluck('name')->implode('<br/>') !!}
                                                            </p>
                                                        </td>
                                                    </tr>
                                                    @endif
                                                    @if(!empty($booking->location))
                                                    <tr>
                                                        <td valign="top" height="20"></td>
                                                    </tr>
                                                    <tr>
                                                        <td valign="top" width="180">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:400; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                Location
                                                            </p>
                                                        </td>
                                                        <td valign="top">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:700; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                {{ $booking->location?->name }}
                                                            </p>
                                                        </td>
                                                    </tr>
                                                    @endif
                                                    @if(!empty($booking->data) && count($booking->data) > 0)
                                                    <tr>
                                                        <td valign="top" height="20"></td>
                                                    </tr>
                                                    <tr>
                                                        <td valign="top" width="180">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:400; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                Additional Details
                                                            </p>
                                                        </td>
                                                        <td valign="top">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:700; line-height:28px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                {!! collect($booking->data ?? [])->filter()->map(fn($value, $key) => ucfirst(str_replace('_', ' ', $key) . ': ' . $value ))->implode('<br/>') !!}
                                                            </p>
                                                        </td>
                                                    </tr>
                                                    @endif
                                                    @if(!empty($booking->notes))
                                                    <tr>
                                                        <td valign="top" height="20"></td>
                                                    </tr>
                                                    <tr>
                                                        <td valign="top" width="180">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:400; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                Notes
                                                            </p>
                                                        </td>
                                                        <td valign="top">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:700; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                {{ $booking->notes }}
                                                            </p>
                                                        </td>
                                                    </tr>
                                                    @endif
                                                </table>
                                            </td>
                                            <td valign="top" width="40" bgcolor="#F2F5F7" style="background-color:#F2F5F7;"></td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                            <tr>
                                <td valign="top" height="20" bgcolor="#F2F5F7" style="background-color:#F2F5F7;border-radius:0px 0px 10px 10px;"></td>
                            </tr>
                        </table>
                    </td>
                    <td valign="top" width="50"></td>
                </tr>
                <tr>
                    <td valign="top" height="50"></td>
                </tr>
            </table>
        </td>
    </tr>
    @if(!empty($booking->intro))
    <!-- CONTENT AREA -->
    <tr>
        <td valign="top">
            <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
                <tr>
                    <td valign="top" width="50"></td>
                    <td valign="top">
                        <p style="color:#20292E; margin:0 0 20px; font-size:18px; font-weight:400; line-height:26px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                            {{ $booking->intro }}
                        </p>
                    </td>
                    <td valign="top" width="50"></td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td valign="top" height="50"></td>
    </tr>
    @endif
    <!-- END OF CONTENT AREA -->
@endsection

@section('footer')
    <tr>
        <td colspan="2" align="center" class="smallText">
            {!! $footer !!}
        </td>
    </tr>
@endsection
