<?php

namespace Tests\Unit\Services;

use App\Services\LocatingService;
use Mtc\MercuryDataModels\Contracts\LocatingServiceEngine;
use Tests\TestCase;

class LocatingServiceTest extends TestCase
{
    protected LocatingService $service;

    protected function setUp(): void
    {
        parent::setUp();

        /** @var LocatingServiceEngine&\PHPUnit\Framework\MockObject\MockObject $mockEngine */
        $mockEngine = $this->createMock(LocatingServiceEngine::class);

        $this->service = new LocatingService($mockEngine);
    }

    public function testGetDistanceBetweenReturnsDistanceInMiles()
    {
        $distance = $this->service->getDistanceBetween(51.5074, -0.1278, 53.4808, -2.2426, 'mi');

        $this->assertIsFloat($distance);
        $this->assertGreaterThan(100, $distance);
        $this->assertLessThan(250, $distance);
    }

    public function testGetDistanceBetweenReturnsDistanceInKilometers()
    {
        // Coordinates: London (51.5074, -0.1278) → Manchester (53.4808, -2.2426)
        $distance = $this->service->getDistanceBetween(51.5074, -0.1278, 53.4808, -2.2426, 'km');

        $this->assertIsFloat($distance);
        $this->assertGreaterThan(160, $distance);
        $this->assertLessThan(300, $distance);
    }

    public function testGetDistanceBetweenReturnsZeroForSameCoordinates()
    {
        $distance = $this->service->getDistanceBetween(40.7128, -74.0060, 40.7128, -74.0060);

        $this->assertSame(0.0, round($distance, 1));
    }
}
