<?php

namespace App\Console\Commands;

use App\Jobs\ProcessMediaUseChunkJob;
use App\MediaRepository;
use Illuminate\Console\Command;
use Illuminate\Support\Collection;
use Mtc\ContentManager\Contracts\MediaUse;

class RegenerateMediaUseSizes extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'media:regenerate-sizes';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Processes media uses to review whether there are missing sizes and trigger regeneration';

    public function __construct(private readonly MediaRepository $repository)
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $total_count = MediaUse::query()->count();
        $this->output->info("Total: $total_count");

        MediaUse::query()
            ->with([
                'media',
                'owner',
            ])
            ->chunk(config('media.resize_chunk_size'), function (Collection $chunk, $index) {
                ProcessMediaUseChunkJob::dispatch($chunk, $this->repository);
            });
    }
}
