<?php

namespace App\Http\Controllers;

use App\Http\Requests\BulkUnpublishRequest;
use App\Http\Requests\ListStockProvidersRequest;
use App\Services\StockManagementService;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class StockManagementController extends Controller
{
    public function __construct(
        private StockManagementService $service
    ) {
    }

    public function listStockProviders(ListStockProvidersRequest $request): JsonResponse
    {
        return response()->json([
            'success' => true,
            'data' => [
                'stock_providers' => $this->service->getAvailableStockProvidersForModel($request->validated('model_type')),
                'model_type' => $request->validated('model_type'),
            ],
            'message' => 'Stock providers retrieved successfully.',
        ]);
    }


    public function bulkUnpublish(BulkUnpublishRequest $request): JsonResponse
    {
        try {
            $total = $this->service->bulkUnpublish($request->validated('model_type'), $request->validated('stock_provider'));
            return response()->json([
                'success' => true,
                'data' => [
                    'total_unpublished' => $total,
                ],
                'message' => "Successfully unpublished {$total} items for provider '{$request->validated('stock_provider')} on model {$request->validated('model_type')}.",
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Failed to unpublish items.',
                'error' => $e->getMessage(),
            ], 500);
        }
    }
}
