<?php

namespace App\Listeners;

use App\Events\NewVehicleImported;
use App\VehicleSpec\Jobs\FetchVehicleSpecData;
use App\VehicleSpec\VehicleSpecServiceHelper;
use Illuminate\Foundation\Bus\DispatchesJobs;

class VehicleSpecLookupOnNewVehicleImport
{
    use DispatchesJobs;

    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(NewVehicleImported $event): void
    {
        if (VehicleSpecServiceHelper::canRunForVehicle($event->vehicle)) {
            $this->dispatch(new FetchVehicleSpecData($event->vehicle));
        }
    }
}
