<?php

namespace App\Master\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Master\ApiUserRepository;
use App\Master\Http\Requests\GetTokenRequest;
use App\Master\Http\Resources\ApiTokenView;
use App\Master\Http\Resources\ApiUserList;
use App\Master\Http\Resources\ApiUserView;
use App\Master\Models\ApiUser;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Http\Response;

class ApiAuthController extends Controller
{
    public function token(GetTokenRequest $request, ApiUserRepository $repository): Response|JsonResource
    {
        try {
            return response(new ApiTokenView(
                $repository->getAccessToken($request->input('client_id'), $request->input('client_secret'))
            ), 200);
        } catch (\Exception $exception) {
            return \response('Access denied', 401);
        }
    }
}
