<?php

namespace App\Services;

use InvalidArgumentException;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleOffer;

class StockManagementService
{
    const MANUAL_ENTRY_LABEL = 'manual-entry';

    private array $model_config = [
        'vehicles' => [
            'model' => Vehicle::class,
            'publish_field' => 'is_published',
        ],
        'vehicle_offers' => [
            'model' => VehicleOffer::class,
            'publish_field' => 'published',
        ],
    ];

    public function getAvailableStockProvidersForModel(string $model): array
    {
        return $this->resolveModelConfig($model)['model']::query()
            ->distinct()
            ->pluck('stock_provider')
            ->map(fn($value) => $value ?? self::MANUAL_ENTRY_LABEL)
            ->values()
            ->toArray();
    }

    public function bulkUnpublish(string $model, string $stock_provider): int
    {
        $query = $this->resolveModelConfig($model)['model']::query();

        $stock_provider === self::MANUAL_ENTRY_LABEL ?
            $query->whereNull('stock_provider') :
            $query->where('stock_provider', $stock_provider);



        return $query->update([
            $this->resolveModelConfig($model)['publish_field'] => false,
        ]);
    }

    private function resolveModelConfig(string $model): array
    {
        return $this->model_config[$model]
            ?? throw new InvalidArgumentException("Invalid model type: {$model}");
    }
}
