<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class CarAndDrivingImageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => 'Car and Driving',
                'name' => 'Sync Images',
                'config_key' => 'app-content-car-and-driving-image-sync-vehicle-types',
                'description' => 'Choose whether to sync images',
                'type' => 'string',
                'value' => 'none',
                 'choices' => [
                    ['value' => 'none', 'name' => 'None'],
                    ['value' => 'used', 'name' => 'For Used Vehicles'],
                    ['value' => 'new',  'name' => 'For New Vehicles'],
                    ['value' => 'all',  'name' => 'For All Vehicles'],
                ],
            ],
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => 'Car and Driving',
                'name' => 'Image Import Behaviour',
                'config_key' => 'app-content-car-and-driving-image-import-behaviour',
                'description' => 'How should images be handled if the vehicle already has images?',
                'type' => 'string',
                'choices' => [
                    ['value' => 'only_if_none', 'name' => 'Import only if vehicle has no images'],
                    ['value' => 'add', 'name' => 'Add to existing images'],
                    ['value' => 'overwrite', 'name' => 'Overwrite existing images'],
                ],
                'value' => 'only_if_none',
            ],
        ];
    }
}
