<?php

declare(strict_types=1);

namespace App\Actions\IntegrationVerification;

use App\Crm\Config\MotordatCrmConfig;
use Illuminate\Support\Facades\Http;

class VerifyMotordatCrm
{
    public function __construct(private readonly MotordatCrmConfig $config)
    {
    }

    public function verify(): bool
    {
        if (empty($this->config->username()) || empty($this->config->password())) {
            return false;
        }

        if (empty($this->config->vendorName())) {
            return false;
        }

        return true;
    }
}
