<?php

declare(strict_types=1);

namespace App\Listeners;

use App\Crm\SendToMotordat;

class AddMotordatCrmDealershipFields
{
    /**
     * Create the event listener.
     */
    public function __construct(private SendToMotordat $motordat)
    {
    }

    /**
     * Handle the event.
     */
    public function handle(object $event): array
    {
        if ($this->motordat->enabled() === false) {
            return [];
        }

        return $this->motordat->dealershipAdditionalDataFields();
    }
}
