<?php

namespace App\Providers;

use App\Events\AutoTraderIdAssignedToVehicle;
use App\Events\DealershipDataValidationEvent;
use App\Events\LoadDealershipDataFields;
use App\Events\LoadFranchiseDataFields;
use App\Events\NewVehicleImported;
use App\Events\NewVehicleOfferImported;
use App\Events\ServiceBookingConfirmedEvent;
use App\Events\StockSyncFinished;
use App\Events\VehiclePriceChangedDuringStockSync;
use App\Events\VehicleRequiredAttributeCheck;
use App\Events\VehicleUpdated;
use App\Events\VehicleUpdatedFromImport;
use App\Listeners\AddAaCarsDealershipFields;
use App\Listeners\AddAutowebDealershipFields;
use App\Listeners\AddCarWowDealershipFields;
use App\Listeners\AddChannelDealershipFields;
use App\Listeners\AddCustomEndpointDealershipFields;
use App\Listeners\AddInventoryDealershipFields;
use App\Listeners\AddAutoTraderDealershipFields;
use App\Listeners\AddCalltracksFrinchiseFields;
use App\Listeners\AddCarGuruDealershipFields;
use App\Listeners\AddCar;
use App\Listeners\AddCarsIrelandDealershipFields;
use App\Listeners\AddCarzoneDealershipFields;
use App\Listeners\AddCodeWeaversDealershipFields;
use App\Listeners\AddDealerWebDealershipFields;
use App\Listeners\AddDMSNavigatorDealershipFields;
use App\Listeners\AddEbayMotorsDealershipFields;
use App\Listeners\AddEnquiryMaxDealershipFields;
use App\Listeners\AddIVendiDealershipFields;
use App\Listeners\AddKeyloopReservationDealershipFields;
use App\Listeners\AddKeyloopRev8DealershipFields;
use App\Listeners\AddModixDealershipFields;
use App\Listeners\AddMoneypennyFranchiseFields;
use App\Listeners\AddMotordatCrmDealershipFields;
use App\Listeners\AddMotoNovoDealershipFields;
use App\Listeners\AddMotorsCoUkDealershipFields;
use App\Listeners\AddMotorsDealershipFields;
use App\Listeners\AddPhyronDealershipFields;
use App\Listeners\AddPinewoodDealershipFields;
use App\Listeners\AddPyxelDealershipField;
use App\Listeners\AddRapidRtcDealershipFields;
use App\Listeners\AddSalesforceCrmDealershipFields;
use App\Listeners\AddSilverBulletDealershipFields;
use App\Listeners\AddSkupenetDealershipFields;
use App\Listeners\AddSkodaDealershipFields;
use App\Listeners\AddStormMsDynamicsDealershipFields;
use App\Listeners\AddVehicleDescriptionFields;
use App\Listeners\AddWhatsappDealershipFields;
use App\Listeners\AutoImagingNotificationResetOnNewVehicle;
use App\Listeners\AutoLoadItNotificationResetOnNewVehicle;
use App\Listeners\IndexVehicleInMeilisearch;
use App\Listeners\SyncVehiclesToMeilisearch;
use App\Listeners\AutosOnShowNotificationResetOnNewVehicle;
use App\Listeners\AutoTraderAIContentActionsForVehicle;
use App\Listeners\CreateSiteOnAutoTraderHub;
use App\Listeners\CreateVehicleAiDescriptionOnNewVehicleImport;
use App\Listeners\CreateVehicleIsPreRegAttribute;
use App\Listeners\DeleteVehicleStockSyncRecords;
use App\Listeners\SendReservationToEnquiryIntegrations;
use App\Listeners\SendServiceBookingToEnquiryIntegrations;
use App\Listeners\SendVehicleToAutoTrader;
use App\Listeners\SetAutoTraderConnectPublishFlag;
use App\Listeners\StoreVehicleImportStockSyncLog;
use App\Listeners\TrackLastLoginTime;
use App\Listeners\TriggerAutoColourMapping;
use App\Listeners\TriggerFilterFeatureAssignment;
use App\Listeners\TriggerFilterReindex;
use App\Listeners\TriggerFinanceExport;
use App\Listeners\TriggerImageSyncAfterStockSyncProcess;
use App\Listeners\TriggerSalesChannelExport;
use App\Listeners\TriggerSalesforceStockExport;
use App\Listeners\TriggerVehicleSearchContentUpdate;
use App\Listeners\RefreshFinanceOnVehiclePriceChange;
use App\Listeners\VehicleFinanceOptionAttributeRequired;
use App\Listeners\VehicleCapIdLookupOnNewVehicleImport;
use App\Listeners\VehicleSpecLookupOnNewVehicleImport;
use App\Listeners\WordReplacements;
use Illuminate\Auth\Events\Login;
use Illuminate\Auth\Events\Registered;
use Illuminate\Auth\Listeners\SendEmailVerificationNotification;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Mtc\MercuryDataModels\Events\LoadVehicleDataFields;
use Mtc\MercuryDataModels\Events\SettingUpdated;
use Mtc\MercuryDataModels\Events\VehicleTrashed;
use Mtc\VehicleReservations\Events\ReservationConfirmedEvent;
use Mtc\VehicleSavings\Listeners\AddSavingsToVehicleFields;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        Registered::class => [
            SendEmailVerificationNotification::class,
        ],
        LoadFranchiseDataFields::class => [
            AddCalltracksFrinchiseFields::class,
            AddMoneypennyFranchiseFields::class,
        ],
        LoadDealershipDataFields::class => [
            AddVehicleDescriptionFields::class,
            AddSilverBulletDealershipFields::class,
            AddRapidRtcDealershipFields::class,
            AddStormMsDynamicsDealershipFields::class,
            AddCustomEndpointDealershipFields::class,
            AddEnquiryMaxDealershipFields::class,
            AddCarGuruDealershipFields::class,
            AddCarWowDealershipFields::class,
            AddAaCarsDealershipFields::class,
            AddAutowebDealershipFields::class,
            AddInventoryDealershipFields::class,
            AddCarzoneDealershipFields::class,
            AddCarsIrelandDealershipFields::class,
            AddPhyronDealershipFields::class,
            AddChannelDealershipFields::class,
            AddMotorsCoUkDealershipFields::class,
            AddPinewoodDealershipFields::class,
            AddModixDealershipFields::class,
            AddEbayMotorsDealershipFields::class,
            AddSkupenetDealershipFields::class,
            AddSkodaDealershipFields::class,
            AddDMSNavigatorDealershipFields::class,
            AddKeyloopRev8DealershipFields::class,
            AddMotorsDealershipFields::class,
            AddMotoNovoDealershipFields::class,
            AddAutoTraderDealershipFields::class,
            AddIVendiDealershipFields::class,
            AddCodeWeaversDealershipFields::class,
            AddDealerWebDealershipFields::class,
            AddSalesforceCrmDealershipFields::class,
            AddKeyloopReservationDealershipFields::class,
            AddPyxelDealershipField::class,
            AddWhatsappDealershipFields::class,
            AddMotordatCrmDealershipFields::class,
        ],
        DealershipDataValidationEvent::class => [
            AddSilverBulletDealershipFields::class,
            AddRapidRtcDealershipFields::class,
            AddStormMsDynamicsDealershipFields::class,
            AddCustomEndpointDealershipFields::class,
            AddEnquiryMaxDealershipFields::class,
            AddCarGuruDealershipFields::class,
            AddCarWowDealershipFields::class,
            AddMotorsCoUkDealershipFields::class,
            AddPinewoodDealershipFields::class,
            AddEbayMotorsDealershipFields::class,
            AddSkupenetDealershipFields::class,
            AddSkodaDealershipFields::class,
            AddDMSNavigatorDealershipFields::class,
            AddKeyloopRev8DealershipFields::class,
            AddMotorsDealershipFields::class,
            AddMotoNovoDealershipFields::class,
            AddAutoTraderDealershipFields::class,
            AddIVendiDealershipFields::class,
            AddCodeWeaversDealershipFields::class,
            AddDealerWebDealershipFields::class,
            AddAaCarsDealershipFields::class,
            AddAutowebDealershipFields::class,
            AddInventoryDealershipFields::class,
            AddCarzoneDealershipFields::class,
            AddCarsIrelandDealershipFields::class,
            AddPhyronDealershipFields::class,
            AddChannelDealershipFields::class,
            AddPyxelDealershipField::class,
            AddWhatsappDealershipFields::class,
            AddMotordatCrmDealershipFields::class,
        ],
        NewVehicleImported::class => [
            StoreVehicleImportStockSyncLog::class,
            VehicleCapIdLookupOnNewVehicleImport::class,
            VehicleSpecLookupOnNewVehicleImport::class,
            CreateVehicleAiDescriptionOnNewVehicleImport::class,
            AutoLoadItNotificationResetOnNewVehicle::class,
            AutoImagingNotificationResetOnNewVehicle::class,
            AutosOnShowNotificationResetOnNewVehicle::class,
            IndexVehicleInMeilisearch::class,
        ],
        VehicleUpdatedFromImport::class => [
            StoreVehicleImportStockSyncLog::class,
            IndexVehicleInMeilisearch::class,
        ],
        NewVehicleOfferImported::class => [
            SetAutoTraderConnectPublishFlag::class,
        ],
        StockSyncFinished::class => [
            TriggerVehicleSearchContentUpdate::class,
            TriggerFilterReindex::class,
            TriggerAutoColourMapping::class,
            TriggerFinanceExport::class,
            TriggerFilterFeatureAssignment::class,
            TriggerSalesforceStockExport::class,
            TriggerSalesChannelExport::class,
            TriggerImageSyncAfterStockSyncProcess::class,
            SyncVehiclesToMeilisearch::class,
        ],
        VehicleUpdated::class => [
            SendVehicleToAutoTrader::class,
//            TriggerFilterReindex::class,
        ],
        VehicleTrashed::class => [
            DeleteVehicleStockSyncRecords::class
        ],
        Login::class => [
            TrackLastLoginTime::class
        ],
        LoadVehicleDataFields::class => [
            AddSavingsToVehicleFields::class
        ],
        VehiclePriceChangedDuringStockSync::class => [
            RefreshFinanceOnVehiclePriceChange::class,
        ],
        VehicleRequiredAttributeCheck::class => [
            VehicleFinanceOptionAttributeRequired::class,
        ],
        'eloquent.creating: *' => [
            WordReplacements::class
        ],
        'eloquent.updating: *' => [
            WordReplacements::class
        ],
        SettingUpdated::class => [
            CreateSiteOnAutoTraderHub::class,
            CreateVehicleIsPreRegAttribute::class,
        ],
        ReservationConfirmedEvent::class => [
            SendReservationToEnquiryIntegrations::class,
        ],
        ServiceBookingConfirmedEvent::class => [
            SendServiceBookingToEnquiryIntegrations::class,
        ],
        AutoTraderIdAssignedToVehicle::class => [
            AutoTraderAIContentActionsForVehicle::class,
        ],
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        //
    }
}
