<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AutowebAPIExportSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Settings::delete('sales-channels-autoweb-ftp-username');
        Settings::delete('sales-channels-autoweb-ftp-password');
        Settings::delete('sales-channels-autoweb-file-name');

        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Autoweb',
                'name' => 'API Key',
                'config_key' => 'sales-channels-autoweb-api-key',
                'type' => 'secret',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-channels-autoweb-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Autoweb',
                'name' => 'Seller ID',
                'config_key' => 'sales-channels-autoweb-seller-id',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-channels-autoweb-enabled,true"
                ]
            ],
        ];
    }
}
