<?php

declare(strict_types=1);

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class MotordatCRMSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Motordat',
                'name' => 'Enabled',
                'config_key' => 'crm-motordat-enabled',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => false,
                'description' => '<a href="https://www.motordat.com/" target="_blank">Motordat</a> CRM integration.'
                    . ' Allows exporting leads to Motordat system.',
                'order' => 0,
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Motordat',
                'name' => 'API Username',
                'config_key' => 'crm-motordat-username',
                'type' => 'string',
                'min_tier' => 'standard',
                'value' => '',
                'validation_rules' => [
                    'required_if:values.crm-motordat-enabled,true',
                ],
                'order' => 1,
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Motordat',
                'name' => 'API Password',
                'config_key' => 'crm-motordat-password',
                'type' => 'secret',
                'min_tier' => 'standard',
                'value' => '',
                'validation_rules' => [
                    'required_if:values.crm-motordat-enabled,true',
                ],
                'order' => 2,
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Motordat',
                'name' => 'Vendor Name',
                'config_key' => 'crm-motordat-vendor-name',
                'type' => 'string',
                'min_tier' => 'standard',
                'value' => '',
                'description' => 'The vendor name provided by Motordat for the API header.',
                'validation_rules' => [
                    'required_if:values.crm-motordat-enabled,true',
                ],
                'order' => 2,
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Motordat',
                'name' => 'Fallback Dealer Code',
                'config_key' => 'motordat-crm-fallback-dealer-code',
                'type' => 'string',
                'min_tier' => 'standard',
                'value' => '',
                'description' => 'If dealer code cannot be determined for a lead this fallback will be used.',
                'order' => 3,
            ],
        ];
    }
}
