<?php

namespace Tests\Tenant;

use App\Filter\FilterIndex;
use Mtc\MercuryDataModels\Filters\ModelFilter;
use Mtc\MercuryDataModels\VehicleModel;
use Tests\TenantTestCase;
use Tests\UserForTenant;

class FilterIndexTest extends TenantTestCase
{
    use UserForTenant;

    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testEscapesWhenNoId()
    {
        $model = new VehicleModel(['name' => 'foo']);
        FilterIndex::index('vehicle', $model, new ModelFilter());
        $this->assertEquals(0, FilterIndex::query()->count());
    }

    public function testEscapesWhenEmptySlug()
    {
        $model = VehicleModel::factory()->create(['name' => '']);
        FilterIndex::index('vehicle', $model, new ModelFilter());
        $this->assertEquals(0, FilterIndex::query()->count());
    }

    public function testIndexing()
    {
        $model = VehicleModel::factory()->create(['name' => 'foo']);
        FilterIndex::index('vehicle', $model, new ModelFilter());
        $this->assertEquals(1, FilterIndex::query()->count());
        $index = FilterIndex::query()->first();
        $this->assertEquals($model->id, $index->filter_id);
        $this->assertEquals('vehicle', $index->filter_type);

    }

    public function testExistingSlug()
    {
        $model = VehicleModel::factory()->create(['name' => 'foo']);
        FilterIndex::index('vehicle', $model, new ModelFilter());

        $model2 = VehicleModel::factory()->create(['name' => 'foo']);
        FilterIndex::index('vehicle', $model2, new ModelFilter());

        $this->assertEquals(2, FilterIndex::query()->count());
        $index = FilterIndex::query()->where('filter_id', $model2->id)->first();
        $this->assertEquals('foo-vehicle', $index->slug);

        $model3 = VehicleModel::factory()->create(['name' => 'foo']);
        FilterIndex::index('vehicle', $model3, new ModelFilter());

        $index = FilterIndex::query()->where('filter_id', $model3->id)->first();
        $this->assertEquals('foo-2', $index->slug);

    }
}
