<?php

namespace App;

use App\Contracts\InteractsWithContentSync;
use Mtc\MercuryDataModels\CatalogOffer;

class CatalogOfferRepository implements InteractsWithContentSync
{
    public function importRecord(array $entry): bool
    {
        $catalogOffer = CatalogOffer::query()->create($entry);

        return $catalogOffer->exists;
    }

    public function canBeImported(array $entry): bool
    {
        return !CatalogOffer::query()
            ->where('name', $entry['name'])
            ->exists();
    }

    public function exportToRemote(array $selections): array
    {
        return CatalogOffer::query()
            ->select([
                'name',
                'subtitle',
                'link',
                'button_text',
                'active',
            ])
            ->whereIn('id', $selections)
            ->get()
            ->toArray();
    }

    public function checkImportEntryValidity(array $dataEntry, array $allEntries): array
    {
        $errors = [];
        if (CatalogOffer::query()->where('name', $dataEntry['name'])->exists()) {
            $errors[] = __('validation.import_name_taken', ['name' => $dataEntry['name']]);
        }

        return [
            'data' => $dataEntry,
            'errors' => $errors,
        ];
    }
}
