<?php

namespace App\Modules\ImageSync;

use App\Jobs\ImportPyxelVehicleImagesJob;
use App\Services\Pyxel as PyxelService;
use Illuminate\Foundation\Bus\DispatchesJobs;

class Pyxel implements ImageSync
{
    use DispatchesJobs;

    public const PROVIDER_NAME = 'pyxel';

    public function __construct(private readonly PyxelService $service)
    {
        //
    }

    public function sync(): void
    {
        $this->dispatch(new ImportPyxelVehicleImagesJob($this->service));
    }
}
