<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class FilterSelectionsOnResultsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'General',
                'name' => 'Selection based filter results',
                'config_key' => 'filter-apply-selections-to-results',
                'type' => 'boolean',
                'value' => true,
                'description' => 'Whether to apply current filtering selections when selecting search results. '
                    . '<strong>Strongly discouraged when stock exceeds 5000 records as will result in slow load times</strong>',
                'order' => 10,
            ],
        ];
    }
}
