<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Mtc\MercuryDataModels\Setting;

class FixEnabledSettingsOrder extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'fix:enabled-settings-order';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Change order for settings with name "Enabled" and type "boolean"';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        Setting::query()
            ->where('name', 'Enabled')
            ->where('type', 'boolean')
            ->update([
                'order' => 0
            ]);

        Setting::query()
            ->where('name', '<>', 'Enabled')
            ->where('order', 0)
            ->update([
                'order' => 1
            ]);
    }
}
