<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AdditionalTrackingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        collect($this->data())
            ->each(fn ($setting) => Settings::make($setting));
    }

    /**
     * Get the seed data.
     */
    private function data(): array
    {
        $redditHref = 'https://business.reddithelp.com/s/article/Install-the-Reddit-Pixel-on-your-website';
        $snapchatHref = 'https://forbusiness.snapchat.com/advertising/snap-pixel';
        $xHref = 'https://business.x.com/en/help/campaign-measurement-and-analytics/conversion-tracking-for-websites';
        $pinterestHref = 'https://help.pinterest.com/en/business/article/install-the-pinterest-tag';
        $clarityHref = 'https://learn.microsoft.com/en-us/clarity/setup-and-installation/clarity-setup';

        return [
            [
                'tab' => 'Site',
                'section' => 'Tracking',
                'group' => 'Tracking Pixels',
                'name' => 'Reddit Pixel',
                'config_key' => 'tracking-reddit-pixel-id',
                'type' => 'secret',
                'value' => '',
                'description' => '<a href="' . $redditHref . '" target="_blank">Reddit</a> ads pixel. '
                    . 'Please <em>enter the unique Pixel ID only</em>!',
            ],
            [
                'tab' => 'Site',
                'section' => 'Tracking',
                'group' => 'Tracking Pixels',
                'name' => 'Snapchat Pixel',
                'config_key' => 'tracking-snapchat-pixel-id',
                'type' => 'secret',
                'value' => '',
                'description' => '<a href="' . $snapchatHref . '" target="_blank">Snapchat</a> ads pixel. '
                    . 'Please <em>enter the unique Pixel ID only</em>!',
            ],
            [
                'tab' => 'Site',
                'section' => 'Tracking',
                'group' => 'Tracking Pixels',
                'name' => 'X Pixel',
                'config_key' => 'tracking-x-pixel-id',
                'type' => 'secret',
                'value' => '',
                'description' => '<a href="' . $xHref . '" target="_blank">X</a> ads pixel. '
                    . 'Please <em>enter the unique Pixel ID only</em>!',
            ],
            [
                'tab' => 'Site',
                'section' => 'Tracking',
                'group' => 'Tracking Pixels',
                'name' => 'Pinterest Tag',
                'config_key' => 'tracking-pinterest-tag-id',
                'type' => 'secret',
                'value' => '',
                'description' => '<a href="' . $pinterestHref . '" target="_blank">Pinterest tag</a>. '
                    . 'Please <em>enter the unique Tag ID only</em>!',
            ],
            [
                'tab' => 'Site',
                'section' => 'Tracking',
                'group' => 'Tracking Pixels',
                'name' => 'Microsoft Clarity Tag',
                'config_key' => 'tracking-microsoft-clarity-project-id',
                'type' => 'secret',
                'value' => '',
                'description' => '<a href="' . $clarityHref . '" target="_blank">Microsoft Clarity</a>. '
                    . 'Please <em>enter the unique Project ID only</em>!',
            ],
        ];
    }
}
