<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AutoTraderCoDriverSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'AI',
                'group' => 'AutoTrader Co Driver',
                'name' => 'Enabled',
                'config_key' => 'ai-content-auto-trader-enabled',
                'min_tier' => 'pro',
                'type' => 'boolean',
                'value' => false,
                'order' => 0,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'AI',
                'group' => 'AutoTrader Co Driver',
                'name' => 'Generate Description When Vehicle Imported',
                'config_key' => 'ai-content-auto-trader-generate-description-on-vehicle-import',
                'min_tier' => 'pro',
                'type' => 'boolean',
                'value' => false,
                'order' => 1,
            ],
        ];
    }
}
