<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class CodeweaversDepositPercentageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run(): void
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'CodeWeavers Deposit Percentages',
                'name' => 'HP (Hire Purchase) Deposit %',
                'config_key' => 'finance-codeweavers-deposit-hp',
                'min_tier' => 'standard',
                'type' => 'int',
                'value' => null,
                'description' => 'Leave empty to use the default deposit percentage',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'CodeWeavers Deposit Percentages',
                'name' => 'PCP (Personal Contract Purchase) Deposit %',
                'config_key' => 'finance-codeweavers-deposit-pcp',
                'min_tier' => 'standard',
                'type' => 'int',
                'value' => null,
                'description' => 'Leave empty to use the default deposit percentage',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'CodeWeavers Deposit Percentages',
                'name' => 'LP (Lease Purchase) Deposit %',
                'config_key' => 'finance-codeweavers-deposit-lp',
                'min_tier' => 'standard',
                'type' => 'int',
                'value' => null,
                'description' => 'Leave empty to use the default deposit percentage',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'CodeWeavers Deposit Percentages',
                'name' => 'CH (Contract Hire) Deposit %',
                'config_key' => 'finance-codeweavers-deposit-ch',
                'min_tier' => 'standard',
                'type' => 'int',
                'value' => null,
                'description' => 'Leave empty to use the default deposit percentage',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'CodeWeavers Deposit Percentages',
                'name' => 'PCH (Personal Contract Hire) Deposit %',
                'config_key' => 'finance-codeweavers-deposit-pch',
                'min_tier' => 'standard',
                'type' => 'int',
                'value' => null,
                'description' => 'Leave empty to use the default deposit percentage',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'CodeWeavers Deposit Percentages',
                'name' => 'CP (Conditional Purchase) Deposit %',
                'config_key' => 'finance-codeweavers-deposit-cp',
                'min_tier' => 'standard',
                'type' => 'int',
                'value' => null,
                'description' => 'Leave empty to use the default deposit percentage',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'CodeWeavers Deposit Percentages',
                'name' => 'CS (Credit Sale) Deposit %',
                'config_key' => 'finance-codeweavers-deposit-cs',
                'min_tier' => 'standard',
                'type' => 'int',
                'value' => null,
                'description' => 'Leave empty to use the default deposit percentage',
            ],
        ];
    }
}
