<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class HideVehicleTypeFilterSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {

        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Vehicle Type',
                'name' => 'Hide in UI',
                'config_key' => 'automotive-vehicle-filters-vehicle_type_hide_in_ui',
                'type' => 'boolean',
                'value' => false,
                'validation_rules' => [
                    "required_if:values.automotive-vehicle-filters-vehicle_type,true"
                ]
            ],
        ];
    }
}
