<?php

namespace App\Listeners;

use App\Crm\SendToRapidRTC;
use App\Modules\Stock\CustomEndpoint;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;

class AddCustomEndpointDealershipFields
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct(private readonly CustomEndpoint $endpoint)
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return array
     */
    public function handle($event)
    {
        if ($this->endpoint->enabled() === false) {
            return [];
        }
        return $this->endpoint->dealershipAdditionalDataFields();
    }
}
