<?php

namespace App\Modules\ServiceBooking\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateBookingPackageRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => [
                'required',
            ],
            'type' => [
                'required',
                Rule::in(['package', 'add-on'])
            ],
            'price' => 'numeric',
            'description' => 'present',
            'applicable_make_id' => 'sometimes',
        ];
    }
}
