<?php

namespace Tests\Unit;

use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Http;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleModel;
use Mtc\VehicleLookup\Config\AutoTraderConfig;
use Mtc\VehicleLookup\Drivers\AutoTrader;
use Tests\TestCase;

class AutoTraderLookupTest extends TestCase
{
    private AutoTrader $driver;

    protected function setUp(): void
    {
        parent::setUp();

        Cache::shouldReceive('remember')->andReturn('fake-access-token');

        config([
            'lookup.drivers.auto-trader.api_key' => 'test-key',
            'lookup.drivers.auto-trader.api_secret' => 'test-secret',
            'lookup.drivers.auto-trader.merchant_id' => '12345',
            'lookup.drivers.auto-trader.live' => false,
        ]);

        $this->driver = new AutoTrader(new AutoTraderConfig());
    }

    public function test_find_derivatives_returns_empty_array_when_generations_missing(): void
    {
        Http::fake([
            'https://api-sandbox.autotrader.co.uk/*' => Http::response([]),
        ]);

        $make = new VehicleMake(['autotrader_id' => '1']);
        $model = new VehicleModel(['autotrader_id' => '2']);

        $result = $this->driver->findDerivatives($make, $model);

        $this->assertIsArray($result);
        $this->assertEmpty($result);
    }

    public function test_find_variants_returns_empty_array_when_derivatives_missing(): void
    {
        Http::fake([
            'https://api-sandbox.autotrader.co.uk/*' => Http::response([]),
        ]);

        $make = new VehicleMake(['autotrader_id' => '1']);
        $model = new VehicleModel(['autotrader_id' => '2']);

        $result = $this->driver->findVariants($make, $model, 'gen-1');

        $this->assertIsArray($result);
        $this->assertEmpty($result);
    }
}
