<?php

namespace App\Listeners;

use App\Events\VehicleRequiredAttributeCheck;
use App\Facades\Settings;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Mtc\MercuryDataModels\Services\FinanceServiceHelper;

class VehicleFinanceOptionAttributeRequired
{
    use DispatchesJobs;

    public function handle(VehicleRequiredAttributeCheck $event): array
    {
        if ($this->showFinanceOptionField()) {
            return [
                'name' => 'Finance option',
                'slug' => 'finance_option',
                'type' => 'number',
                'count' => 1,
            ];
        }
        return [];
    }

    private function showFinanceOptionField(): bool
    {
        return FinanceServiceHelper::getProvider() === 'ivendi'
            && Settings::get('finance-risk-based-pricing-enable-finance-options');
    }
}
