<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AutoTraderHubExportSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock push from website to AutoTrader',
                'name' => 'Do not publish demo vehicles',
                'config_key' => 'automotive-sales-channels-auto-trader-unpublish-demo',
                'type' => 'boolean',
                'value' => true,
                'order' => 99,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock push from website to AutoTrader',
                'name' => 'Do not publish vehicles without images',
                'config_key' => 'automotive-sales-channels-auto-trader-unpublish-no-images',
                'type' => 'boolean',
                'value' => true,
                'order' => 99,
            ],
        ];
    }
}
