<?php

namespace Database\Seeders\Tenant;

class BookTestDriveUsedSeeder extends GeneralEnquirySeeder
{
    public function run()
    {
        $this->createForm('Book a Test Drive - Used Vehicle', 'Test Drive', [
            [
                'name' => 'Date',
                'type' => 'date_field',
                'is_active' => 1,
                'validation' => ['required', 'date']
            ],
            [
                'name' => 'Preferred Time of Day',
                'type' => 'checkbox_list',
                'is_active' => 1,
                'validation' => ['required'],
                'data' => [
                    'component' => 'CheckboxList',
                    'componentName' => 'CheckboxList',
                    'meta' => [
                        'content' => 'Anytime:Anytime
Morning:Morning
Afternoon:Afternoon
Evening:Evening',
                        'options' => [
                            'items' => [
                                ['name' => 'Anytime', 'value' => 'Anytime'],
                                ['name' => 'Morning', 'value' => 'Morning'],
                                ['name' => 'Afternoon', 'value' => 'Afternoon'],
                                ['name' => 'Evening', 'value' => 'Evening'],
                            ]
                        ]
                    ]
                ]
            ],
            [
                'name' => 'Vehicle ID',
                'type' => 'vehicle_id',
                'is_active' => 1,
                'is_enquiry_subject' => 1,
                'validation' => ['required']
            ]
        ]);
    }
}
