<?php

namespace Tests\Feature\Controllers;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\MercuryDataModels\Billable;
use Tests\TestCase;
use Tests\UserForTenant;

class BillableControllerTest extends TestCase
{
    use RefreshDatabase;
    use UserForTenant;
    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testIndex()
    {
        Billable::factory(3)->create(['type' => 'a']);
        Billable::factory(4)->create(['type' => 'b']);
        Billable::factory(5)->create(['type' => 'c']);
        $response = $this->actingAs($this->getUser())
            ->getJson(route('billables.index', [], false));

        $response->assertStatus(200);

        $this->assertIsArray($response->json());
        $this->assertCount(3, $response->json());
        $this->assertCount(3, $response->json('a'));
        $this->assertCount(4, $response->json('b'));
        $this->assertCount(5, $response->json('c'));
    }
}
