<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\App;
use Mtc\ContentManager\Contracts\FormField;

class AttributeView extends JsonResource
{
    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'attribute' => $this->resource->toArray(),
            'types' => collect(config('pages.field_types', []))
                ->map(fn ($class) => App::make($class))
                ->map(fn (FormField $field) => [
                    'name' => $field::NAME,
                    'value' => $field::TYPE,
                    'component' => $field->getComponent(),
                ])->values(),
        ];
    }
}
