<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class PageTypeSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->getData())
            ->each(fn ($data) => Settings::make($data));
    }

    private function getData()
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => 'Blog',
                'name' => 'Blog enabled',
                'config_key' => 'app-content-blog-enabled',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Enable blog type content pages on site',
                'order' => 1,
            ],
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => 'News',
                'name' => 'News enabled',
                'config_key' => 'app-content-news-enabled',
                'type' => 'boolean',
                'value' => true,
                'description' => 'Enable news type content pages on site',
                'order' => 3,
            ],
        ];
    }
}
